#ifndef __CStringTokeniser__
#define __CStringTokeniser__

//	===========================================================================

#include "CString.hpp"
using Exponent::Basics::CString;

//	===========================================================================

namespace Exponent
{
	namespace Basics
	{
		/**
		 * @class CStringTokeniser CStringTokeniser.hpp
		 * @brief String divider
		 *
		 * @code
		 * CStringTokeniser tokeniser("hello, everybody");
		 * while(tokeniser.hasMoreTokens())
		 * {
		 *     // Get the token
		 *	   char *token = tokeniser.getNextToken();
		 *     
		 *     // Display the token
		 *     std::cout << "Token is = " << token << std::endl;
		 *
		 *     // Delete the token buffer
		 *     FREE_ARRAY_POINTER(token);
		 * }
		 * @endcode
		 *
		 * @date 21/08/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CStringTokeniser.hpp,v 1.5 2007/02/08 21:06:44 paul Exp $
		 */
		class CStringTokeniser : public CCountedObject
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			const static long CSTRING_TOKENISER_MAX_STRING = 2048;	/**< Max length string that you can use */

//	===========================================================================

			/**
			 * Construction
			 * @param string The string to tokenise
			 */
			CStringTokeniser(const char *string);

			/**
			 * Construction
			 * @param string The string to tokenise
			 */
			CStringTokeniser(const CString &string);

			/**
			 * Construction
			 * @param string The string to tokenise
			 * @param token The token to split on
			 */
			CStringTokeniser(const char *string, const char token);

			/**
			 * Construction
			 * @param string The string to tokenise
			 * @param token The token to split on
			 */
			CStringTokeniser(const CString &string, const char token);

			/**
			 * Destruction
			 */
			virtual ~CStringTokeniser();

//	===========================================================================

			/**
			 * Get the number of tokens in the string
			 * @retval long The number of tokens
			 */
			virtual long getNumberOfTokens();

			/**
			 * Are there more tokens available to iterate over?
			 * @retval bool True if more tokens available, false otherwise
			 */
			virtual bool hasMoreTokens();

//	===========================================================================

			/**
			 * Set the character to split on
			 * @param token The character to split on
			 */
			virtual void setTokenizationCharacter(const char token);

			/**
			 * Set the string to be tokenised
			 * @param string The string to tokenise
			 */
			virtual void setStringToTokenize(const char *string);

//	===========================================================================

			/**
			 * Get the next token
			 * @retval char* The next token available. You are responsible for its deletion
			 */
			virtual char *getNextToken();

			/**
			 * Get the next token
			 * @param string On return holds the token
			 * @retval bool true if got the next token, false otherwise
			 */
			bool getNextToken(CString &string);

//	===========================================================================

		protected:

//	===========================================================================

			long m_numberOfTokens;								/**< the tokens */
			long m_numberOfTokensReturned;						/**< no returned */
			long m_lastTokenPosition;							/**< index of last token */
			char m_string[CSTRING_TOKENISER_MAX_STRING];		/**< the tokenisation string */
			char m_token;										/**< the token */

//	===========================================================================

		};
	}
}
#endif	// End of CStringTokeniser.hpp
